<?php
session_start();
include 'conexao.php';



// Puxa todas as turmas do banco
$turmas = $conn->query("
    SELECT id, CONCAT(classe, '-', nome, '.-', curso, '-', turno) AS nome
    FROM turmas
    WHERE ano = '2025/2026'
    ORDER BY nome ASC
");
?>
<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="UTF-8">
  <title>Painel de Acesso</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="stylesheet" href="adminlte/plugins/fontawesome-free/css/all.min.css">
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background: linear-gradient(to bottom, #003366, #005f99);
      color: white;
      display: flex;
      justify-content: center;
      align-items: center;
      min-height: 100vh;
      margin: 0;
      padding: 20px;
    }

    .login-box {
      background: white;
      color: #333;
      border-radius: 15px;
      padding: 40px 30px;
      box-shadow: 0 5px 20px rgba(0,0,0,0.2);
      width: 100%;
      max-width: 400px;
      text-align: center;
    }

    .login-box h2 {
      margin-bottom: 25px;
      color: #003366;
      font-size: 1.6em;
    }

    label {
      font-weight: 600;
      margin-top: 10px;
      display: block;
      text-align: left;
      font-size: 1em;
    }

    select, input[type="password"] {
      width: 100%;
      padding: 14px;
      margin-top: 6px;
      margin-bottom: 20px;
      border-radius: 6px;
      border: 1px solid #ccc;
      font-size: 1em;
      box-sizing: border-box;
    }

    button {
      width: 100%;
      padding: 14px;
      background: #003366;
      color: white;
      border: none;
      font-weight: bold;
      border-radius: 6px;
      cursor: pointer;
      font-size: 1em;
      transition: background 0.3s ease;
    }

    button:hover {
      background: #005f99;
    }

    .alterar-senha {
      text-align: center;
      margin-top: 20px;
    }

    .alterar-senha a {
      color: #003366;
      text-decoration: none;
      font-size: 0.95em;
    }

    .alterar-senha a:hover {
      text-decoration: underline;
    }

    .mensagem-erro {
      color: red;
      font-size: 0.95em;
      margin-bottom: 15px;
    }
  </style>
</head>

<body>
  <div class="login-box">
    <h2>Bem-vindo à EduKKap</h2>

    <?php if (isset($_SESSION['erro_login_aluno'])): ?>
      <div class="mensagem-erro"><?= $_SESSION['erro_login_aluno']; unset($_SESSION['erro_login_aluno']); ?></div>
    <?php endif; ?>

    <form action="validar_login_aluno.php" method="POST" autocomplete="off">
      
      <label for="turma_id">Turma</label>
      <select name="turma_id" id="turma_id" required>
        <option value="">Selecione a Turma</option>
        <?php while ($turma = $turmas->fetch_assoc()): ?>
          <option value="<?= $turma['id'] ?>"><?= htmlspecialchars($turma['nome']) ?></option>
        <?php endwhile; ?>
      </select>

      <label for="nome">Nome do Aluno</label>
      <select name="nome" id="nome" required>
        <option value="">Selecione a Turma Primeiro</option>
      </select>

      <label for="senha">Senha</label>
      <input type="password" name="senha" id="senha" required>

      <button type="submit">Entrar</button>
    </form>

    <div class="alterar-senha">
      <a href="#">Esqueceu a senha?</a>
    </div>
  </div>

  <script>
    document.getElementById('turma_id').addEventListener('change', function () {
      const turmaId = this.value;
      const alunoSelect = document.getElementById('nome');
      alunoSelect.innerHTML = '<option>Carregando...</option>';

      if (turmaId) {
        fetch('get_alunos.php?turma_id=' + turmaId)
          .then(res => res.json())
          .then(data => {
            alunoSelect.innerHTML = '<option value="">Selecione o Aluno</option>';
            data.forEach(aluno => {
              const option = document.createElement('option');
              option.value = aluno.nome;
              option.textContent = aluno.nome;
              alunoSelect.appendChild(option);
            });
          })
          .catch(() => {
            alunoSelect.innerHTML = '<option value="">Erro ao carregar alunos</option>';
          });
      } else {
        alunoSelect.innerHTML = '<option value="">Selecione a Turma Primeiro</option>';
      }
    });
  </script>
</body>
</html>
